package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.SourceData;
import com.xforceplus.jccolgate.service.ISourceDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-02
 */
@RestController
public class SourceDataController {

  @Autowired
  private ISourceDataService sourceDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sourceData ${table.comment}
   * @return
   */
  @GetMapping("/sourcedatas" )
  public XfR getSourceDatas(XfPage page, SourceData sourceData) {
    return XfR.ok(sourceDataServiceImpl.page(page, Wrappers.query(sourceData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sourcedatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sourceDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sourceData ${table.comment}
   * @return XfR
   */
  @PostMapping("/sourcedatas")
  public XfR save(@RequestBody SourceData sourceData) {
     return XfR.ok(sourceDataServiceImpl.save(sourceData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sourceData ${table.comment}
   * @return XfR
   */
  @PutMapping("/sourcedatas/{id}")
  public XfR putUpdate(@RequestBody SourceData sourceData,@PathVariable Long id) {
      sourceData.setId(id);
      return XfR.ok(sourceDataServiceImpl.updateById(sourceData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sourceData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sourcedatas/{id}")
  public XfR patchUpdate(@RequestBody SourceData sourceData,@PathVariable Long id) {
      SourceData upsourceData = sourceDataServiceImpl.getById(id);
      if(upsourceData != null){
        upsourceData = ObjectCopyUtils.copyProperties(sourceData,upsourceData,true);
      }
      return XfR.ok(sourceDataServiceImpl.updateById(upsourceData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sourcedatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sourceDataServiceImpl.removeById(id));
  }

  @PostMapping("/sourcedatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "source_data");
     params.put("request", condition);

     return XfR.ok(sourceDataServiceImpl.querys(params));
  }

}
