package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.SalesBillDetails;
import com.xforceplus.jccolgate.service.ISalesBillDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-05
 */
@RestController
public class SalesBillDetailsController {

  @Autowired
  private ISalesBillDetailsService salesBillDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillDetails ${table.comment}
   * @return
   */
  @GetMapping("/salesbilldetailss" )
  public XfR getSalesBillDetailss(XfPage page, SalesBillDetails salesBillDetails) {
    return XfR.ok(salesBillDetailsServiceImpl.page(page, Wrappers.query(salesBillDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbilldetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesBillDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbilldetailss")
  public XfR save(@RequestBody SalesBillDetails salesBillDetails) {
     return XfR.ok(salesBillDetailsServiceImpl.save(salesBillDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesBillDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbilldetailss/{id}")
  public XfR putUpdate(@RequestBody SalesBillDetails salesBillDetails,@PathVariable Long id) {
      salesBillDetails.setId(id);
      return XfR.ok(salesBillDetailsServiceImpl.updateById(salesBillDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesBillDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbilldetailss/{id}")
  public XfR patchUpdate(@RequestBody SalesBillDetails salesBillDetails,@PathVariable Long id) {
      SalesBillDetails upsalesBillDetails = salesBillDetailsServiceImpl.getById(id);
      if(upsalesBillDetails != null){
        upsalesBillDetails = ObjectCopyUtils.copyProperties(salesBillDetails,upsalesBillDetails,true);
      }
      return XfR.ok(salesBillDetailsServiceImpl.updateById(upsalesBillDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbilldetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/salesbilldetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_details");
     params.put("request", condition);

     return XfR.ok(salesBillDetailsServiceImpl.querys(params));
  }

}
