package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.ScannedDat;
import com.xforceplus.jccolgate.service.IScannedDatService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-05
 */
@RestController
public class ScannedDatController {

  @Autowired
  private IScannedDatService scannedDatServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param scannedDat ${table.comment}
   * @return
   */
  @GetMapping("/scanneddats" )
  public XfR getScannedDats(XfPage page, ScannedDat scannedDat) {
    return XfR.ok(scannedDatServiceImpl.page(page, Wrappers.query(scannedDat)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/scanneddats/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(scannedDatServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param scannedDat ${table.comment}
   * @return XfR
   */
  @PostMapping("/scanneddats")
  public XfR save(@RequestBody ScannedDat scannedDat) {
     return XfR.ok(scannedDatServiceImpl.save(scannedDat));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param scannedDat ${table.comment}
   * @return XfR
   */
  @PutMapping("/scanneddats/{id}")
  public XfR putUpdate(@RequestBody ScannedDat scannedDat,@PathVariable Long id) {
      scannedDat.setId(id);
      return XfR.ok(scannedDatServiceImpl.updateById(scannedDat));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param scannedDat ${table.comment}
   * @return XfR
   */
  @PatchMapping("/scanneddats/{id}")
  public XfR patchUpdate(@RequestBody ScannedDat scannedDat,@PathVariable Long id) {
      ScannedDat upscannedDat = scannedDatServiceImpl.getById(id);
      if(upscannedDat != null){
        upscannedDat = ObjectCopyUtils.copyProperties(scannedDat,upscannedDat,true);
      }
      return XfR.ok(scannedDatServiceImpl.updateById(upscannedDat));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/scanneddats/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(scannedDatServiceImpl.removeById(id));
  }

  @PostMapping("/scanneddats/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "scanned_dat");
     params.put("request", condition);

     return XfR.ok(scannedDatServiceImpl.querys(params));
  }

}
