package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.DiscountRuleConfig;
import com.xforceplus.jccolgate.service.IDiscountRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-13
 */
@RestController
public class DiscountRuleConfigController {

  @Autowired
  private IDiscountRuleConfigService discountRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discountRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/discountruleconfigs" )
  public XfR getDiscountRuleConfigs(XfPage page, DiscountRuleConfig discountRuleConfig) {
    return XfR.ok(discountRuleConfigServiceImpl.page(page, Wrappers.query(discountRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discountruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discountRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discountRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/discountruleconfigs")
  public XfR save(@RequestBody DiscountRuleConfig discountRuleConfig) {
     return XfR.ok(discountRuleConfigServiceImpl.save(discountRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discountRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/discountruleconfigs/{id}")
  public XfR putUpdate(@RequestBody DiscountRuleConfig discountRuleConfig,@PathVariable Long id) {
      discountRuleConfig.setId(id);
      return XfR.ok(discountRuleConfigServiceImpl.updateById(discountRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discountRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discountruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody DiscountRuleConfig discountRuleConfig,@PathVariable Long id) {
      DiscountRuleConfig updiscountRuleConfig = discountRuleConfigServiceImpl.getById(id);
      if(updiscountRuleConfig != null){
        updiscountRuleConfig = ObjectCopyUtils.copyProperties(discountRuleConfig,updiscountRuleConfig,true);
      }
      return XfR.ok(discountRuleConfigServiceImpl.updateById(updiscountRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discountruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discountRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/discountruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discount_rule_config");
     params.put("request", condition);

     return XfR.ok(discountRuleConfigServiceImpl.querys(params));
  }

}
