package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.ExpectionLog;
import com.xforceplus.jccolgate.service.IExpectionLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-18
 */
@RestController
public class ExpectionLogController {

  @Autowired
  private IExpectionLogService expectionLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expectionLog ${table.comment}
   * @return
   */
  @GetMapping("/expectionlogs" )
  public XfR getExpectionLogs(XfPage page, ExpectionLog expectionLog) {
    return XfR.ok(expectionLogServiceImpl.page(page, Wrappers.query(expectionLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expectionlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expectionLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expectionLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/expectionlogs")
  public XfR save(@RequestBody ExpectionLog expectionLog) {
     return XfR.ok(expectionLogServiceImpl.save(expectionLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expectionLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/expectionlogs/{id}")
  public XfR putUpdate(@RequestBody ExpectionLog expectionLog,@PathVariable Long id) {
      expectionLog.setId(id);
      return XfR.ok(expectionLogServiceImpl.updateById(expectionLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expectionLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expectionlogs/{id}")
  public XfR patchUpdate(@RequestBody ExpectionLog expectionLog,@PathVariable Long id) {
      ExpectionLog upexpectionLog = expectionLogServiceImpl.getById(id);
      if(upexpectionLog != null){
        upexpectionLog = ObjectCopyUtils.copyProperties(expectionLog,upexpectionLog,true);
      }
      return XfR.ok(expectionLogServiceImpl.updateById(upexpectionLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expectionlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expectionLogServiceImpl.removeById(id));
  }

  @PostMapping("/expectionlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expection_log");
     params.put("request", condition);

     return XfR.ok(expectionLogServiceImpl.querys(params));
  }

}
