package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.SalesBillDetailCount;
import com.xforceplus.jccolgate.service.ISalesBillDetailCountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-18
 */
@RestController
public class SalesBillDetailCountController {

  @Autowired
  private ISalesBillDetailCountService salesBillDetailCountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillDetailCount ${table.comment}
   * @return
   */
  @GetMapping("/salesbilldetailcounts" )
  public XfR getSalesBillDetailCounts(XfPage page, SalesBillDetailCount salesBillDetailCount) {
    return XfR.ok(salesBillDetailCountServiceImpl.page(page, Wrappers.query(salesBillDetailCount)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbilldetailcounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillDetailCountServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesBillDetailCount ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbilldetailcounts")
  public XfR save(@RequestBody SalesBillDetailCount salesBillDetailCount) {
     return XfR.ok(salesBillDetailCountServiceImpl.save(salesBillDetailCount));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesBillDetailCount ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbilldetailcounts/{id}")
  public XfR putUpdate(@RequestBody SalesBillDetailCount salesBillDetailCount,@PathVariable Long id) {
      salesBillDetailCount.setId(id);
      return XfR.ok(salesBillDetailCountServiceImpl.updateById(salesBillDetailCount));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesBillDetailCount ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbilldetailcounts/{id}")
  public XfR patchUpdate(@RequestBody SalesBillDetailCount salesBillDetailCount,@PathVariable Long id) {
      SalesBillDetailCount upsalesBillDetailCount = salesBillDetailCountServiceImpl.getById(id);
      if(upsalesBillDetailCount != null){
        upsalesBillDetailCount = ObjectCopyUtils.copyProperties(salesBillDetailCount,upsalesBillDetailCount,true);
      }
      return XfR.ok(salesBillDetailCountServiceImpl.updateById(upsalesBillDetailCount));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbilldetailcounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillDetailCountServiceImpl.removeById(id));
  }

  @PostMapping("/salesbilldetailcounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_detail_count");
     params.put("request", condition);

     return XfR.ok(salesBillDetailCountServiceImpl.querys(params));
  }

}
