package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.TaskLog;
import com.xforceplus.jccolgate.service.ITaskLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-18
 */
@RestController
public class TaskLogController {

  @Autowired
  private ITaskLogService taskLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taskLog ${table.comment}
   * @return
   */
  @GetMapping("/tasklogs" )
  public XfR getTaskLogs(XfPage page, TaskLog taskLog) {
    return XfR.ok(taskLogServiceImpl.page(page, Wrappers.query(taskLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tasklogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taskLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taskLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/tasklogs")
  public XfR save(@RequestBody TaskLog taskLog) {
     return XfR.ok(taskLogServiceImpl.save(taskLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taskLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/tasklogs/{id}")
  public XfR putUpdate(@RequestBody TaskLog taskLog,@PathVariable Long id) {
      taskLog.setId(id);
      return XfR.ok(taskLogServiceImpl.updateById(taskLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taskLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tasklogs/{id}")
  public XfR patchUpdate(@RequestBody TaskLog taskLog,@PathVariable Long id) {
      TaskLog uptaskLog = taskLogServiceImpl.getById(id);
      if(uptaskLog != null){
        uptaskLog = ObjectCopyUtils.copyProperties(taskLog,uptaskLog,true);
      }
      return XfR.ok(taskLogServiceImpl.updateById(uptaskLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tasklogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taskLogServiceImpl.removeById(id));
  }

  @PostMapping("/tasklogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "task_log");
     params.put("request", condition);

     return XfR.ok(taskLogServiceImpl.querys(params));
  }

}
