package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.ProductCodeConfig;
import com.xforceplus.jccolgate.service.IProductCodeConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-06
 */
@RestController
public class ProductCodeConfigController {

  @Autowired
  private IProductCodeConfigService productCodeConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productCodeConfig ${table.comment}
   * @return
   */
  @GetMapping("/productcodeconfigs" )
  public XfR getProductCodeConfigs(XfPage page, ProductCodeConfig productCodeConfig) {
    return XfR.ok(productCodeConfigServiceImpl.page(page, Wrappers.query(productCodeConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productcodeconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productCodeConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productCodeConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/productcodeconfigs")
  public XfR save(@RequestBody ProductCodeConfig productCodeConfig) {
     return XfR.ok(productCodeConfigServiceImpl.save(productCodeConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productCodeConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/productcodeconfigs/{id}")
  public XfR putUpdate(@RequestBody ProductCodeConfig productCodeConfig,@PathVariable Long id) {
      productCodeConfig.setId(id);
      return XfR.ok(productCodeConfigServiceImpl.updateById(productCodeConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productCodeConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productcodeconfigs/{id}")
  public XfR patchUpdate(@RequestBody ProductCodeConfig productCodeConfig,@PathVariable Long id) {
      ProductCodeConfig upproductCodeConfig = productCodeConfigServiceImpl.getById(id);
      if(upproductCodeConfig != null){
        upproductCodeConfig = ObjectCopyUtils.copyProperties(productCodeConfig,upproductCodeConfig,true);
      }
      return XfR.ok(productCodeConfigServiceImpl.updateById(upproductCodeConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productcodeconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productCodeConfigServiceImpl.removeById(id));
  }

  @PostMapping("/productcodeconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_code_config");
     params.put("request", condition);

     return XfR.ok(productCodeConfigServiceImpl.querys(params));
  }

}
