package com.xforceplus.jccolgate.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.ProductNameKeyword;
import com.xforceplus.jccolgate.service.IProductNameKeywordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-06
 */
@RestController
public class ProductNameKeywordController {

  @Autowired
  private IProductNameKeywordService productNameKeywordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productNameKeyword ${table.comment}
   * @return
   */
  @GetMapping("/productnamekeywords" )
  public XfR getProductNameKeywords(XfPage page, ProductNameKeyword productNameKeyword) {
    return XfR.ok(productNameKeywordServiceImpl.page(page, Wrappers.query(productNameKeyword)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productnamekeywords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productNameKeywordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productNameKeyword ${table.comment}
   * @return XfR
   */
  @PostMapping("/productnamekeywords")
  public XfR save(@RequestBody ProductNameKeyword productNameKeyword) {
     return XfR.ok(productNameKeywordServiceImpl.save(productNameKeyword));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productNameKeyword ${table.comment}
   * @return XfR
   */
  @PutMapping("/productnamekeywords/{id}")
  public XfR putUpdate(@RequestBody ProductNameKeyword productNameKeyword,@PathVariable Long id) {
      productNameKeyword.setId(id);
      return XfR.ok(productNameKeywordServiceImpl.updateById(productNameKeyword));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productNameKeyword ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productnamekeywords/{id}")
  public XfR patchUpdate(@RequestBody ProductNameKeyword productNameKeyword,@PathVariable Long id) {
      ProductNameKeyword upproductNameKeyword = productNameKeywordServiceImpl.getById(id);
      if(upproductNameKeyword != null){
        upproductNameKeyword = ObjectCopyUtils.copyProperties(productNameKeyword,upproductNameKeyword,true);
      }
      return XfR.ok(productNameKeywordServiceImpl.updateById(upproductNameKeyword));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productnamekeywords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productNameKeywordServiceImpl.removeById(id));
  }

  @PostMapping("/productnamekeywords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_name_keyword");
     params.put("request", condition);

     return XfR.ok(productNameKeywordServiceImpl.querys(params));
  }

}
