package com.xforceplus.jccqyy.controller;


/**
 * 物流信息feign客户端
 *
 * @author ultraman
 * @date 2022-10-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccqyy.entity.Logistic;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface LogisticFeignApi {

  /**
   * 通过id查询物流信息
   * @param  id
   * @return R
   */
  @GetMapping("/logistic/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增物流信息
   * @param logistic 物流信息
   * @return R
   */
  @PostMapping("/logistic/add")
  public R save(@RequestBody Logistic logistic);

  /**
   * 修改物流信息
   * @param logistic 物流信息
   * @return R
   */
  @PostMapping("/logistic/update")
  public R updateById(@RequestBody Logistic logistic);

  /**
   * 通过id删除物流信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/logistic/del/{id}" )
  public R removeById(@PathVariable Long id);

}