package com.xforceplus.jccqyy.controller;


/**
 * 进项发票明细信息feign客户端
 *
 * @author ultraman
 * @date 2022-10-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccqyy.entity.PurchaserInvoiceItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface PurchaserInvoiceItemFeignApi {

  /**
   * 通过id查询进项发票明细信息
   * @param  id
   * @return R
   */
  @GetMapping("/purchaserInvoiceItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增进项发票明细信息
   * @param purchaserInvoiceItem 进项发票明细信息
   * @return R
   */
  @PostMapping("/purchaserInvoiceItem/add")
  public R save(@RequestBody PurchaserInvoiceItem purchaserInvoiceItem);

  /**
   * 修改进项发票明细信息
   * @param purchaserInvoiceItem 进项发票明细信息
   * @return R
   */
  @PostMapping("/purchaserInvoiceItem/update")
  public R updateById(@RequestBody PurchaserInvoiceItem purchaserInvoiceItem);

  /**
   * 通过id删除进项发票明细信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/purchaserInvoiceItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}