package com.xforceplus.jccqyy.controller;


/**
 * 套票号生成（顺序生成+换期清空）feign客户端
 *
 * @author ultraman
 * @date 2022-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccqyy.entity.PackageOfTicketNoCreate;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface PackageOfTicketNoCreateFeignApi {

  /**
   * 通过id查询套票号生成（顺序生成+换期清空）
   * @param  id
   * @return R
   */
  @GetMapping("/packageOfTicketNoCreate/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增套票号生成（顺序生成+换期清空）
   * @param packageOfTicketNoCreate 套票号生成（顺序生成+换期清空）
   * @return R
   */
  @PostMapping("/packageOfTicketNoCreate/add")
  public R save(@RequestBody PackageOfTicketNoCreate packageOfTicketNoCreate);

  /**
   * 修改套票号生成（顺序生成+换期清空）
   * @param packageOfTicketNoCreate 套票号生成（顺序生成+换期清空）
   * @return R
   */
  @PostMapping("/packageOfTicketNoCreate/update")
  public R updateById(@RequestBody PackageOfTicketNoCreate packageOfTicketNoCreate);

  /**
   * 通过id删除套票号生成（顺序生成+换期清空）
   * @param  id
   * @return R
   */
  @DeleteMapping("/packageOfTicketNoCreate/del/{id}" )
  public R removeById(@PathVariable Long id);

}