package com.xforceplus.jccqyy.controller;


/**
 * 进项发票主表信息feign客户端
 *
 * @author ultraman
 * @date 2022-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccqyy.entity.PurchaserInvoiceMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface PurchaserInvoiceMainFeignApi {

  /**
   * 通过id查询进项发票主表信息
   * @param  id
   * @return R
   */
  @GetMapping("/purchaserInvoiceMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增进项发票主表信息
   * @param purchaserInvoiceMain 进项发票主表信息
   * @return R
   */
  @PostMapping("/purchaserInvoiceMain/add")
  public R save(@RequestBody PurchaserInvoiceMain purchaserInvoiceMain);

  /**
   * 修改进项发票主表信息
   * @param purchaserInvoiceMain 进项发票主表信息
   * @return R
   */
  @PostMapping("/purchaserInvoiceMain/update")
  public R updateById(@RequestBody PurchaserInvoiceMain purchaserInvoiceMain);

  /**
   * 通过id删除进项发票主表信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/purchaserInvoiceMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}