package com.xforceplus.jccqyy.controller;


/**
 * 红字信息feign客户端
 *
 * @author ultraman
 * @date 2022-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccqyy.entity.RedLetter;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface RedLetterFeignApi {

  /**
   * 通过id查询红字信息
   * @param  id
   * @return R
   */
  @GetMapping("/redLetter/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增红字信息
   * @param redLetter 红字信息
   * @return R
   */
  @PostMapping("/redLetter/add")
  public R save(@RequestBody RedLetter redLetter);

  /**
   * 修改红字信息
   * @param redLetter 红字信息
   * @return R
   */
  @PostMapping("/redLetter/update")
  public R updateById(@RequestBody RedLetter redLetter);

  /**
   * 通过id删除红字信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/redLetter/del/{id}" )
  public R removeById(@PathVariable Long id);

}