package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum AuthStatusEnum {

    _0("0", "默认"),
    _1("1", "不可勾选"),
    _2("2", "未勾选"),
    _3("3", "勾选中"),
    _4("4", "已勾选"),
    _5("5", "勾选失败"),
    _6("6", "抵扣异常"),
    _8("8", "已确认抵扣");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
