package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 失信状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum BlackStatusEnum {

    _0("0", "正常"),
    _1("1", "系统黑名单"),
    _2("2", "国税黑名单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BlackStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
