package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 记账状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum ChargeUpStatusEnum {

    _0("0", "未记账(默认)"),
    _1("1", "已记账"),
    _2("2", "记账失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeUpStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
