package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum CheckStatusEnum {

    _2("2", "验真成功"),
    _3("3", "验真失败"),
    _1("1", "验真中"),
    _0("0", "未验真");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
