package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票匹配状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum MatchStatusEnum {

    _0("0", "未匹配(默认)"),
    _1("1", "匹配中"),
    _2("2", "已匹配"),
    _3("3", "有冲突"),
    _4("4", "待确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
