package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 报销状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum ReimbursementStatusEnum {

    _0("0", "未报销"),
    _1("1", "报销中"),
    _2("2", "已报销"),
    _3("3", "报销异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReimbursementStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
