package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 报账状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum ReportStatusEnum {

    _0("0", "未报账"),
    _1("1", "已报账"),
    _2("2", "取消报账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReportStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
