package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 核销状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum SaleConfirmStatusEnum {

    _0("0", "未核销(默认)"),
    _1("1", "部分核销"),
    _2("2", "已核销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SaleConfirmStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
