package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方开具状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum SellerSyncStatusEnum {

    _0("0", "默认"),
    _1("1", "无销方信息（非协同）"),
    _2("2", "销方信息未到（协同）"),
    _3("3", "销方信息已到（协同）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerSyncStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
