package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 敏感词控制等级枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum SenseWordLevelEnum {

    _0("0", "弱控"),
    _1("1", "强控"),
    _2("2", "默认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SenseWordLevelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
