package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 进转出类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum TurnOutTypeEnum {

    _1("1", "免税项目用"),
    _2("2", "集体福利、个人消费"),
    _3("3", "非正常损失"),
    _4("4", "简易计税方法征税项目用"),
    _5("5", "免抵退税办法不得抵扣的进项税额"),
    _6("6", "纳税检查调减进项税额"),
    _7("7", "红字专用发票信息表注明的进项税额"),
    _8("8", "上期留抵税额抵减欠税"),
    _9("9", "上期留抵税额退税"),
    _10("10", "其他应作进项税额转出的情形");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TurnOutTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
