package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 查验状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum VeriStatusEnum {

    _0("0", "未查验(默认)"),
    _1("1", "待查验"),
    _2("2", "查验中"),
    _3("3", "查验成功"),
    _4("4", "查验失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VeriStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
