package com.xforceplus.jccqyy.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaserInvoice implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("invoiceNo")
  private String invoiceNo;

  @TableField("invoiceCode")
  private String invoiceCode;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("invoiceType")
  private String invoiceType;

  @TableField("invoiceSheet")
  private String invoiceSheet;

  @TableField("sellerName")
  private String sellerName;

  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  @TableField("purchaserName")
  private String purchaserName;

  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  @TableField("taxRate")
  private String taxRate;

  @TableField("taxAmount")
  private String taxAmount;

  @TableField("amountWithTax")
  private String amountWithTax;

  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  @TableField("checkStatus")
  private String checkStatus;

  @TableField("imageUrl")
  private String imageUrl;

  @TableField("packageOfTicketNo")
  private String packageOfTicketNo;

  private Long total;

  @TableField("packageStatus")
  private String packageStatus;

  @TableField("orgCode")
  private String orgCode;

  @TableField("orgId")
  private String orgId;

  @TableField("scanBatchNo")
  private String scanBatchNo;

  @TableField("scanTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanTime;

  @TableField("sourceJson")
  private String sourceJson;




}
