package com.xforceplus.jccqyy.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaserInvoiceItem implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("invoiceId")
  private Long invoiceId;

  @TableField("invoiceCode")
  private String invoiceCode;

  @TableField("invoiceNo")
  private String invoiceNo;

  @TableField("cargoCode")
  private String cargoCode;

  @TableField("cargoName")
  private String cargoName;

  @TableField("itemSpec")
  private String itemSpec;

  @TableField("quantityUnit")
  private String quantityUnit;

  private BigDecimal quantity;

  @TableField("taxRate")
  private String taxRate;

  @TableField("unitPrice")
  private BigDecimal unitPrice;

  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("discountWithoutTax")
  private BigDecimal discountWithoutTax;

  @TableField("discountRate")
  private BigDecimal discountRate;

  @TableField("taxItem")
  private String taxItem;

  @TableField("goodsNoVer")
  private String goodsNoVer;

  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  @TableField("goodsErpNo")
  private String goodsErpNo;

  @TableField("plateNumber")
  private String plateNumber;

  @TableField("vehicleType")
  private String vehicleType;

  @TableField("tollStartDate")
  private String tollStartDate;

  @TableField("tollEndDate")
  private String tollEndDate;

  @TableField("complianceBatchId")
  private Long complianceBatchId;

  @TableField("complianceStatus")
  private String complianceStatus;

  @TableField("taxPreFlag")
  private String taxPreFlag;

  @TableField("taxPreContent")
  private String taxPreContent;

  @TableField("taxRateType")
  private String taxRateType;

  @TableField("taxDedunction")
  private BigDecimal taxDedunction;

  @TableField("discountFlag")
  private String discountFlag;

  @TableField("priceMethod")
  private String priceMethod;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




}
