package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-20
 */
public enum InvoiceTypeEnum {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    SE("se", "增值税电子专用发票"),
    CB("cb", "区块链电子普通发票"),
    CJ("cj", "增值税普通发票（卷票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeEnum fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "se":
                return SE;
            case "cb":
                return CB;
            case "cj":
                return CJ;
            default:
                return null;
        }
    }
}
