package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-24
 */
public enum InvoiceOrigEnum {

    _0("0", "默认"),
    _11("11", "销方直连"),
    _12("12", "销方抽取"),
    _13("13", "销方手工回填"),
    _21("21", "国税验真"),
    _22("22", "国税底账"),
    _31("31", "影像识别");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceOrigEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOrigEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "21":
                return _21;
            case "22":
                return _22;
            case "31":
                return _31;
            default:
                return null;
        }
    }
}
