package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 电子底账状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum AuthSyncStatusEnum {

    _0("0", "未获取(默认)"),
    _1("1", "未勾选"),
    _2("2", "已勾选"),
    _3("3", "底账确认失败"),
    _4("4", "已确认"),
    _5("5", "不可勾选确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthSyncStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
