package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 不合规内容枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum ComplianceContentEnum {

    _1("1", "销方失信"),
    _2("2", "敏感词"),
    _3("3", "购方信息不一致"),
    _4("4", "发票状态异常"),
    _5("5", "退回"),
    _6("6", "数据源不一致");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ComplianceContentEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
