package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据源比对是否一致枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum DataOkFlagEnum {

    _0("0", "未知（默认）"),
    _1("1", "一致"),
    _2("2", "不一致");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataOkFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
