package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 源文件类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum OriginFileEnum {

    _0("0", "无源文件"),
    _1("1", "PDF"),
    _2("2", "OFD");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OriginFileEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
