package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否有销货清单枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum SaleListFlagEnum {

    _0("0", "未知（默认）"),
    _1("1", "有"),
    _2("2", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SaleListFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
