package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 协同来源枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum SellerOriginEnum {

    _0("0", "默认"),
    _11("11", "销方直连"),
    _12("12", "销方抽取"),
    _13("13", "销方手工回填");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerOriginEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
