package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum StatusEnum {

    _0("0", "默认"),
    _1("1", "正常"),
    _2("2", "作废"),
    _3("3", "被红冲"),
    _4("4", "部分红冲"),
    _7("7", "异常"),
    _8("8", "失控"),
    _9("9", "删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
