package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 零税率标志枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum TaxRateTypeEnum {

    _0("0", "非0税率（默认）"),
    _1("1", "出口退税"),
    _2("2", "免税"),
    _3("3", "不征税"),
    _4("4", "普通0税率");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxRateTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
