package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 进转出状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum TurnOutStatusEnum {

    _0("0", "未转出"),
    _1("1", "部分转出"),
    _2("2", "已转出");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TurnOutStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
