package com.xforceplus.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预警处理状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-01-12
 */
public enum WarnHandleStatusEnum {

    _0("0", "未处理"),
    _1("1", "无需预警"),
    _2("2", "处理中"),
    _3("3", "处理完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WarnHandleStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
