package com.xforceplus.jccr39.controller;


/**
 * 系统工作流程实例变量对象feign客户端
 *
 * @author ultraman
 * @date 2025-09-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccr39.entity.SysFlowInsVar;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cr39")
public interface SysFlowInsVarFeignApi {

  /**
   * 通过id查询系统工作流程实例变量对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowInsVar/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流程实例变量对象
   * @param sysFlowInsVar 系统工作流程实例变量对象
   * @return R
   */
  @PostMapping("/sysFlowInsVar/add")
  public R save(@RequestBody SysFlowInsVar sysFlowInsVar);

  /**
   * 修改系统工作流程实例变量对象
   * @param sysFlowInsVar 系统工作流程实例变量对象
   * @return R
   */
  @PostMapping("/sysFlowInsVar/update")
  public R updateById(@RequestBody SysFlowInsVar sysFlowInsVar);

  /**
   * 通过id删除系统工作流程实例变量对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowInsVar/del/{id}" )
  public R removeById(@PathVariable Long id);

}