package com.xforceplus.jccr39.controller;


/**
 * 资源系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-09-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccr39.entity.SystemResource;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cr39")
public interface SystemResourceFeignApi {

  /**
   * 通过id查询资源系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemResource/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资源系统对象
   * @param systemResource 资源系统对象
   * @return R
   */
  @PostMapping("/systemResource/add")
  public R save(@RequestBody SystemResource systemResource);

  /**
   * 修改资源系统对象
   * @param systemResource 资源系统对象
   * @return R
   */
  @PostMapping("/systemResource/update")
  public R updateById(@RequestBody SystemResource systemResource);

  /**
   * 通过id删除资源系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemResource/del/{id}" )
  public R removeById(@PathVariable Long id);

}