package com.xforceplus.jccr39.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
public enum TaxInvoiceSource {

    QD("qd", "数电"),
    SK("sk", "税控");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code){
        switch(code) {
            case "qd":
                return QD;
            case "sk":
                return SK;
            default:
                return null;
        }
    }
}
