package com.xforceplus.jccr39.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-22
 */
public enum ApplyStatus {

    _01("01", "无需确认"),
    _02("02", "销方录入待购方确认"),
    _03("03", "购方录入待销方确认"),
    _04("04", "购销双方已确认"),
    _05("05", "作废（销方录入购方否认）"),
    _06("06", "作废（购方录入销方否认）"),
    _07("07", "作废（超72小时未确认）"),
    _08("08", "作废（发起方已撤销）"),
    _09("09", "作废（确认后撤销）"),
    _10("10", "作废（异常凭证）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
