package com.xforceplus.jccr39.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cx_bill_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-22
 */
public enum CxBillType {

    对账单("对账单", "对账单"),
    确认函("确认函", "确认函");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CxBillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CxBillType fromCode(String code){
        switch(code) {
            case "对账单":
                return 对账单;
            case "确认函":
                return 确认函;
            default:
                return null;
        }
    }
}
