package com.xforceplus.jccr39.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-10
 */
public enum InvoiceType {

    QS("qs", "电子发票(增值税专用发票)"),
    QC("qc", "电子发票(普通发票)");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "qs":
                return QS;
            case "qc":
                return QC;
            default:
                return null;
        }
    }
}
