package com.xforceplus.jccr39.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccr39.entity.SystemExtendDict;
import com.xforceplus.jccr39.service.ISystemExtendDictService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统枚举扩展对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-29
 */
@RestController
public class SystemExtendDictController {

  @Autowired
  private ISystemExtendDictService systemExtendDictServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemExtendDict 系统枚举扩展对象
   * @return
   */
  @GetMapping("/systemextenddicts" )
  public XfR getSystemExtendDicts(XfPage page, SystemExtendDict systemExtendDict) {
    return XfR.ok(systemExtendDictServiceImpl.page(page, Wrappers.query(systemExtendDict)));
  }

  /**
   * 通过id查询系统枚举扩展对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemextenddicts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemExtendDictServiceImpl.getById(id));
  }

  /**
   * 新增系统枚举扩展对象
   * @param systemExtendDict 系统枚举扩展对象
   * @return XfR
   */
  @PostMapping("/systemextenddicts")
  public XfR save(@RequestBody SystemExtendDict systemExtendDict) {
     return XfR.ok(systemExtendDictServiceImpl.save(systemExtendDict));
  }

  /**
   * 修改-传入修改后的全部数据系统枚举扩展对象
   * @param systemExtendDict 系统枚举扩展对象
   * @return XfR
   */
  @PutMapping("/systemextenddicts/{id}")
  public XfR putUpdate(@RequestBody SystemExtendDict systemExtendDict,@PathVariable Long id) {
      systemExtendDict.setId(id);
      return XfR.ok(systemExtendDictServiceImpl.updateById(systemExtendDict));
  }

  /**
   * 修改-传入修改的数据系统枚举扩展对象
   * @param systemExtendDict 系统枚举扩展对象
   * @return XfR
   */
  @PatchMapping("/systemextenddicts/{id}")
  public XfR patchUpdate(@RequestBody SystemExtendDict systemExtendDict,@PathVariable Long id) {
      SystemExtendDict upsystemExtendDict = systemExtendDictServiceImpl.getById(id);
      if(upsystemExtendDict != null){
        upsystemExtendDict = ObjectCopyUtils.copyProperties(systemExtendDict,upsystemExtendDict,true);
      }
      return XfR.ok(systemExtendDictServiceImpl.updateById(upsystemExtendDict));
  }

  /**
   * 通过id删除系统枚举扩展对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemextenddicts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemExtendDictServiceImpl.removeById(id));
  }

  @PostMapping("/systemextenddicts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_extend_dict");
     params.put("request", condition);

     return XfR.ok(systemExtendDictServiceImpl.querys(params));
  }

}
