package com.xforceplus.jccr39.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccr39.entity.CompareRedLetters;
import com.xforceplus.jccr39.service.ICompareRedLettersService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-22
 */
@RestController
public class CompareRedLettersController {

  @Autowired
  private ICompareRedLettersService compareRedLettersServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareRedLetters ${table.comment}
   * @return
   */
  @GetMapping("/compareredletterss" )
  public XfR getCompareRedLetterss(XfPage page, CompareRedLetters compareRedLetters) {
    return XfR.ok(compareRedLettersServiceImpl.page(page, Wrappers.query(compareRedLetters)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareredletterss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareRedLettersServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareRedLetters ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareredletterss")
  public XfR save(@RequestBody CompareRedLetters compareRedLetters) {
     return XfR.ok(compareRedLettersServiceImpl.save(compareRedLetters));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareRedLetters ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareredletterss/{id}")
  public XfR putUpdate(@RequestBody CompareRedLetters compareRedLetters,@PathVariable Long id) {
      compareRedLetters.setId(id);
      return XfR.ok(compareRedLettersServiceImpl.updateById(compareRedLetters));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareRedLetters ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareredletterss/{id}")
  public XfR patchUpdate(@RequestBody CompareRedLetters compareRedLetters,@PathVariable Long id) {
      CompareRedLetters upcompareRedLetters = compareRedLettersServiceImpl.getById(id);
      if(upcompareRedLetters != null){
        upcompareRedLetters = ObjectCopyUtils.copyProperties(compareRedLetters,upcompareRedLetters,true);
      }
      return XfR.ok(compareRedLettersServiceImpl.updateById(upcompareRedLetters));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareredletterss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareRedLettersServiceImpl.removeById(id));
  }

  @PostMapping("/compareredletterss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_red_letters");
     params.put("request", condition);

     return XfR.ok(compareRedLettersServiceImpl.querys(params));
  }

}
