package com.xforceplus.jccr39.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccr39.entity.RedLettersList;
import com.xforceplus.jccr39.service.IRedLettersListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-10
 */
@RestController
public class RedLettersListController {

  @Autowired
  private IRedLettersListService redLettersListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLettersList ${table.comment}
   * @return
   */
  @GetMapping("/redletterslists" )
  public XfR getRedLettersLists(XfPage page, RedLettersList redLettersList) {
    return XfR.ok(redLettersListServiceImpl.page(page, Wrappers.query(redLettersList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletterslists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLettersListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLettersList ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletterslists")
  public XfR save(@RequestBody RedLettersList redLettersList) {
     return XfR.ok(redLettersListServiceImpl.save(redLettersList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLettersList ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletterslists/{id}")
  public XfR putUpdate(@RequestBody RedLettersList redLettersList,@PathVariable Long id) {
      redLettersList.setId(id);
      return XfR.ok(redLettersListServiceImpl.updateById(redLettersList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLettersList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletterslists/{id}")
  public XfR patchUpdate(@RequestBody RedLettersList redLettersList,@PathVariable Long id) {
      RedLettersList upredLettersList = redLettersListServiceImpl.getById(id);
      if(upredLettersList != null){
        upredLettersList = ObjectCopyUtils.copyProperties(redLettersList,upredLettersList,true);
      }
      return XfR.ok(redLettersListServiceImpl.updateById(upredLettersList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletterslists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLettersListServiceImpl.removeById(id));
  }

  @PostMapping("/redletterslists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letters_list");
     params.put("request", condition);

     return XfR.ok(redLettersListServiceImpl.querys(params));
  }

}
