package com.xforceplus.jcdisney.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 报表统计
 * </p>
 *
 * @author ultraman
 * @since 2022-08-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReportStatistics implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 公司id
   */
  @TableField("companyId")
  private Long companyId;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 设备序号
   */
  @TableField("deviceSeq")
  private String deviceSeq;

  /**
   * 业态
   */
  private String format;

  /**
   * 纸质普票
   */
  @TableField("paperOrdinaryInvoice")
  private String paperOrdinaryInvoice;

  /**
   * 纸质专票
   */
  @TableField("paperSpecialInvoice")
  private String paperSpecialInvoice;

  /**
   * 电子普票
   */
  @TableField("electronicOrdinaryInvoice")
  private String electronicOrdinaryInvoice;

  /**
   * 电子专票
   */
  @TableField("electronicSpecialInvoice")
  private String electronicSpecialInvoice;

  /**
   * 统计期数
   */
  @TableField("statisticsTerm")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statisticsTerm;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("companyId", companyId);
      map.put("companyName", companyName);
      map.put("deviceSeq", deviceSeq);
      map.put("format", format);
      map.put("paperOrdinaryInvoice", paperOrdinaryInvoice);
      map.put("paperSpecialInvoice", paperSpecialInvoice);
      map.put("electronicOrdinaryInvoice", electronicOrdinaryInvoice);
      map.put("electronicSpecialInvoice", electronicSpecialInvoice);
      map.put("statisticsTerm", BocpGenUtils.toTimestamp(statisticsTerm));
      return map;
  }

  public static ReportStatistics fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReportStatistics entity = new ReportStatistics();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceSeq")) {
      Object obj = map.get("deviceSeq");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceSeq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("format")) {
      Object obj = map.get("format");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFormat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperOrdinaryInvoice")) {
      Object obj = map.get("paperOrdinaryInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperOrdinaryInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperSpecialInvoice")) {
      Object obj = map.get("paperSpecialInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperSpecialInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicOrdinaryInvoice")) {
      Object obj = map.get("electronicOrdinaryInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setElectronicOrdinaryInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSpecialInvoice")) {
      Object obj = map.get("electronicSpecialInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setElectronicSpecialInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticsTerm")) {
      Object obj = map.get("statisticsTerm");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatisticsTerm(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStatisticsTerm((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStatisticsTerm(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatisticsTerm(null);
      }
    }
    return entity;
  }
}
